#include maps\mp\gametypes\_hud_util;
#include maps\mp\_utility;
#include common_scripts\utility;
#include user_scripts\mp_patches\gunfight\hud;

setupGame(){
	//setDvarIfUninitialized("forced_weapon", "random" );
	level.loudoutSwap = getdvarint("change_loudout_round");
	if(getdvarint("Same_Loudout_Count") >= level.loudoutSwap || getDvar("loudout_weapons_primary") == "" || getDvar("forced_weapon") != getDvar("current_weapon")){
		//level assignWeaponClasses();
		level getRandomPerks();
		level getRandomSpecial();
		level getRandomEquipment();
		level pickRandomWeapons();
		//level getRandomSecondary();
		setDvar("Same_Loudout_Count", 1 );
		setDvar("current_weapon", getDvar("forced_weapon") );
		setDvar("loudout_weapons_primary", level.loudout["weapons"]["primary"]);
		setDvar("loudout_weapons_secondary", level.loudout["weapons"]["secondary"]);
		setDvar("loudout_special_grenade", 	level.loudout["equipment"]["grenade"]);
		setDvar("loudout_special_class", level.loudout["equipment"]["class"]);
		setDvar("loudout_equipment_grenade", level.loudout["special"]["grenade"]);
		setDvar("loudout_equipment_class", level.loudout["special"]["class"]);
		setDvar("loudout_perk_1", level.loudout["perk"]["1"]);
		setDvar("loudout_perk_2", level.loudout["perk"]["2"]);
		setDvar("loudout_perk_3", level.loudout["perk"]["3"]);
	}
	else{
		setDvar("Same_Loudout_Count", (getdvarint("Same_Loudout_Count")+1) );
		level.loudout["weapons"]["primary"] = getDvar("loudout_weapons_primary");
		level.loudout["weapons"]["secondary"] = getDvar("loudout_weapons_secondary");
		level.loudout["equipment"]["grenade"] = getDvar("loudout_special_grenade");
		level.loudout["equipment"]["class"] = getDvar("loudout_special_class");
		level.loudout["special"]["grenade"] = getDvar("loudout_equipment_grenade");
		level.loudout["special"]["class"] = getDvar("loudout_equipment_class");
		level.loudout["perk"]["1"] = getDvar("loudout_perk_1");
		level.loudout["perk"]["2"] = getDvar("loudout_perk_2");
		level.loudout["perk"]["3"] = getDvar("loudout_perk_3");
	}
	/*level.loudout["weapons"]["primary"] = "h2_mp7";
	level.loudout["weapons"]["secondary"] = "mp40_mp";
	level.loudout["perk"]["1"] = "specialty_scavenger_upgrade";
	level.loudout["special"]["grenade"] = "throwingknife_rhand_mp";
	level.loudout["special"]["class"] = "smoke";
	level.equipment["grenade"] = "throwingknife_mp";
	level.equipment["class"] = "throwingknife";
	level.loudout["equipment"] = level.equipment;*/
	level.weaponsSet = true;
}

pickRandomWeapons(){
	weapon_secondary_shotguns = [];
	weapon_snipers = [];
	weapon_bolts = [];
	weapon_heavys = [];
	weapon_smgs = [];
	weapon_assaults = [];
	weapon_secondary_machine_pistols = [];
	weapon_pistols = [];
	weapon_melees = [];
	weapon_projectiles = [];
	weapon_others = [];

	/*weapon_snipers[0] = "h2_m40a3_mp_m40a3scope_ogscope";
	weapon_snipers[weapon_snipers.size] = "h2_m40a3_mp_m40a3scope_ogscope_xmag";
	weapon_snipers[weapon_snipers.size] = "h2_m40a3_mp_m40a3scope_ogscope_silencersniper";
	weapon_snipers[weapon_snipers.size] = "h2_as50_mp_as50scope_ogscopeiw5";
	weapon_snipers[weapon_snipers.size] = "h2_as50_mp_as50scope_ogscopeiw5_xmag";
	weapon_snipers[weapon_snipers.size] = "h2_as50_mp_as50scope_ogscopeiw5_silencersniper";
	weapon_snipers[weapon_snipers.size] = "h2_msr_mp_msrscope_ogscopeiw5";
	weapon_snipers[weapon_snipers.size] = "h2_msr_mp_msrscope_ogscopeiw5_xmag";
	weapon_snipers[weapon_snipers.size] = "h2_msr_mp_msrscope_ogscopeiw5_silencersniper";
	weapon_snipers[weapon_snipers.size] = "h2_msr_mp_msrscope_ogscopeiw5_silencersniper_xmag";
	weapon_snipers[weapon_snipers.size] = "h2_msr_mp_fmj_msrscope_silencersniper";
	weapon_snipers[weapon_snipers.size] = "h2_msr_mp_fmj_msrscope_xmag";
	weapon_snipers[weapon_snipers.size] = "h2_cheytac_mp_cheytacscope_ogscope";
	weapon_snipers[weapon_snipers.size] = "h2_cheytac_mp_cheytacscope_ogscope_xmag";
	weapon_snipers[weapon_snipers.size] = "h2_cheytac_mp_cheytacscope_ogscope_silencersniper_xmag";
	weapon_snipers[weapon_snipers.size] = "h2_cheytac_mp_cheytacscope_fmj_ogscope_xmag";
	weapon_snipers[weapon_snipers.size] = "h2_cheytac_mp_cheytacscope_fmj_ogscope_silencersniper";
	weapon_snipers[weapon_snipers.size] = "h2_d25s_mp_d25sscope_ogscope";
	weapon_snipers[weapon_snipers.size] = "h2_d25s_mp_d25sscope_ogscope_xmag";
	weapon_snipers[weapon_snipers.size] = "h2_d25s_mp_d25sscope_ogscope_fmj_xmag";
	weapon_snipers[weapon_snipers.size] = "h2_l118a_mp_l118ascope_ogscopeiw5";
	weapon_snipers[weapon_snipers.size] = "h2_l118a_mp_l118ascope_ogscopeiw5_xmag";
	weapon_snipers[weapon_snipers.size] = "h2_l118a_mp_l118ascope_ogscopeiw5_silencersniper";
	weapon_snipers[weapon_snipers.size] = "h2_l118a_mp_fmj_l118ascope_ogscopeiw5_silencersniper";
	weapon_snipers[weapon_snipers.size] = "h2_l118a_mp_l118ascope_ogscopeiw5_silencersniper_xmag";
	weapon_snipers[weapon_snipers.size] = "h2_l118a_mp_fmj_l118ascope_ogscopeiw5_xmag";
	weapon_snipers[weapon_snipers.size] = "h2_m21_mp_m21scope_ogscope";
	weapon_snipers[weapon_snipers.size] = "h2_m21_mp_m21scope_ogscope_xmag";
	weapon_snipers[weapon_snipers.size] = "h2_m21_mp_m21scope_ogscope_silencersniper";
	weapon_snipers[weapon_snipers.size] = "h2_m21_mp_fmj_m21scope_ogscope";
	weapon_snipers[weapon_snipers.size] = "h2_m21_mp_fmj_m21scope_ogscope_xmag";
	weapon_snipers[weapon_snipers.size] = "h2_m21_mp_fmj_m21scope_ogscope_silencersniper";
	weapon_snipers[weapon_snipers.size] = "h2_barrett_mp_barrettscope_ogscope";
	weapon_snipers[weapon_snipers.size] = "h2_barrett_mp_barrettscope_ogscope_xmag";
	weapon_snipers[weapon_snipers.size] = "h2_barrett_mp_barrettscope_ogscope_silencersniper";
	weapon_snipers[weapon_snipers.size] = "h2_barrett_mp_barrettscope_fmj_ogscope_xmag";
	weapon_snipers[weapon_snipers.size] = "h2_barrett_mp_barrettscope_fmj_ogscope_silencersniper";
	weapon_snipers[weapon_snipers.size] = "h2_usr_mp_ogscopeusr_usrscope";
	weapon_snipers[weapon_snipers.size] = "h2_usr_mp_fmj_usrscope_xmag";
	weapon_snipers[weapon_snipers.size] = "h2_usr_mp_fmj_ogscopeusr_silencersniper_usrscope";
	weapon_snipers[weapon_snipers.size] = "h2_usr_mp_silencersniper_usrscope_xmag";
	weapon_snipers[weapon_snipers.size] = "h2_usr_mp_fmj_usrscope_xmag";
	weapon_snipers[weapon_snipers.size] = "h2_usr_mp_fmj_silencersniper_usrscope";
	weapon_bolts[0] = "h2_m40a3_mp_m40a3scope_ogscope";
	weapon_bolts[weapon_bolts.size] = "h2_m40a3_mp_m40a3scope_ogscope_xmag";
	weapon_bolts[weapon_bolts.size] = "h2_m40a3_mp_m40a3scope_ogscope_silencersniper";
	weapon_bolts[weapon_bolts.size] = "h2_msr_mp_msrscope_ogscopeiw5";
	weapon_bolts[weapon_bolts.size] = "h2_msr_mp_msrscope_ogscopeiw5_xmag";
	weapon_bolts[weapon_bolts.size] = "h2_msr_mp_msrscope_ogscopeiw5_silencersniper";
	weapon_bolts[weapon_bolts.size] = "h2_msr_mp_msrscope_ogscopeiw5_silencersniper_xmag";
	weapon_bolts[weapon_bolts.size] = "h2_msr_mp_fmj_msrscope_silencersniper";
	weapon_bolts[weapon_bolts.size] = "h2_msr_mp_fmj_msrscope_xmag";
	weapon_bolts[weapon_bolts.size] = "h2_cheytac_mp_cheytacscope_ogscope";
	weapon_bolts[weapon_bolts.size] = "h2_cheytac_mp_cheytacscope_ogscope_xmag";
	weapon_bolts[weapon_bolts.size] = "h2_cheytac_mp_cheytacscope_ogscope_silencersniper_xmag";
	weapon_bolts[weapon_bolts.size] = "h2_cheytac_mp_cheytacscope_fmj_ogscope_silencersniper";
	weapon_bolts[weapon_bolts.size] = "h2_cheytac_mp_cheytacscope_fmj_ogscope_xmag";
	weapon_bolts[weapon_bolts.size] = "h2_cheytac_mp_cheytacscope_fmj_ogscope_silencersniper";
	weapon_bolts[weapon_bolts.size] = "h2_l118a_mp_l118ascope_ogscopeiw5";
	weapon_bolts[weapon_bolts.size] = "h2_l118a_mp_l118ascope_ogscopeiw5_xmag";
	weapon_bolts[weapon_bolts.size] = "h2_l118a_mp_l118ascope_ogscopeiw5_silencersniper";
	weapon_bolts[weapon_bolts.size] = "h2_l118a_mp_fmj_l118ascope_ogscopeiw5_silencersniper";
	weapon_bolts[weapon_bolts.size] = "h2_l118a_mp_l118ascope_ogscopeiw5_silencersniper_xmag";
	weapon_bolts[weapon_bolts.size] = "h2_l118a_mp_fmj_l118ascope_ogscopeiw5_xmag";
	weapon_bolts[weapon_bolts.size] = "h2_usr_mp_ogscopeusr_usrscope";
	weapon_bolts[weapon_bolts.size] = "h2_usr_mp_fmj_usrscope_xmag";
	weapon_bolts[weapon_bolts.size] = "h2_usr_mp_fmj_ogscopeusr_silencersniper_usrscope";
	weapon_bolts[weapon_bolts.size] = "h2_usr_mp_silencersniper_usrscope_xmag";
	weapon_bolts[weapon_bolts.size] = "h2_usr_mp_fmj_usrscope_xmag";
	weapon_bolts[weapon_bolts.size] = "h2_usr_mp_fmj_silencersniper_usrscope";*/

	
	foreach(weapon in level.weaponList){
		switch(maps\mp\_utility::getweaponclass(weapon)){
			case "weapon_secondary_shotgun":
				weapon_secondary_shotguns[weapon_secondary_shotguns.size] = weapon;
				weapon_secondary_shotguns++;
			break;
			case "weapon_sniper":
				if(weapon == "h2_wa2000_mp"){
					break;
				}
				if(isBoltAction(weapon)){
					weapon_bolts[weapon_bolts.size] = weapon;
					weapon_bolts++;
				}
				weapon_snipers[weapon_snipers.size] = weapon;
				weapon_snipers++;
			break;
			case "weapon_heavy":
				weapon_heavys[weapon_heavys.size] = weapon;
				weapon_heavys++;
			break;
			case "weapon_smg":
				weapon_smgs[weapon_smgs.size] = weapon;
				weapon_smgs++;
			break;
			case "weapon_assault":
				weapon_assaults[weapon_assaults.size] = weapon;
				weapon_assaults++;
			break;
			case "weapon_secondary_machine_pistol":
				weapon_secondary_machine_pistols[weapon_secondary_machine_pistols.size] = weapon;
				weapon_secondary_machine_pistols++;
			break;
			case "weapon_pistol":
				weapon_pistols[weapon_pistols.size] = weapon;
				weapon_pistols++;
			break;
			case "weapon_melee":
				weapon_melees[weapon_melees.size] = weapon;
				weapon_melees++;
			break;
			case "weapon_projectile":
				weapon_projectiles[weapon_projectiles.size] = weapon;
				weapon_projectiles++;
			break;
			default:
				//logPrint("\n"+maps\mp\_utility::getweaponclass(weapon));
				weapon_others[weapon_others.size] = weapon;
				weapon_others++;
			break;
		}
	}
	level.testing22 = weapon_snipers[0];
	pWeapon = "";
	switch(randomint(7)){
		case 0:
			pWeapon = getRandomAttachments(weapon_secondary_shotguns[randomint(weapon_secondary_shotguns.size)]);
		break;
		case 1:
			pWeapon = getRandomAttachments(weapon_snipers[randomint(weapon_snipers.size)]);
		break;
		case 2:
			pWeapon = getRandomAttachments(weapon_heavys[randomint(weapon_heavys.size)]);
		break;
		case 3:
			pWeapon = getRandomAttachments(weapon_smgs[randomint(weapon_smgs.size)]);
		break;
		case 4:
			pWeapon = getRandomAttachments(weapon_assaults[randomint(weapon_assaults.size)]);
		break;
		case 5:
			pWeapon = getRandomAttachments(weapon_secondary_machine_pistols[randomint(weapon_secondary_machine_pistols.size)]);
		break;
		case 6:
			pWeapon = getRandomAttachments(weapon_pistols[randomint(weapon_pistols.size)]);
		break;
	}
	//iPrintLn("pWeapon: "+pWeapon);
	level.loudout["weapons"]["primary"] = pWeapon;

	var_2 = getDvarInt("gf_secondarygunchance");
	if(var_2 < 0)
		var_2 = 0;
	else if(var_2 > 100)
		var_2 = 100;
	
	var_3 = randomint(101);
	chance = (var_2 > var_3);

	//iPrintLn(var_2 + " > "+ var_3);

	sWeapon = "";

	if(chance){
		var_0 = true;
		while(getweaponbasename(sWeapon) == getweaponbasename(level.loudout["weapons"]["primary"]) || var_0){
			var_0 = false;
			//iPrintLn(getweaponbasenameresult(sWeapon) + " == " + getweaponbasenameresult(level.loudout["weapons"]["primary"]));
			switch(randomint(4)){
			case 0:
				sWeapon = getRandomAttachments(weapon_secondary_shotguns[randomint(weapon_secondary_shotguns.size)]);
			break;
			case 1:
				sWeapon = getRandomAttachments(weapon_secondary_machine_pistols[randomint(weapon_secondary_machine_pistols.size)]);
			break;
			case 2:
				sWeapon = getRandomAttachments(weapon_pistols[randomint(weapon_pistols.size)]);
			break;
			case 3:
				switch(randomint(7)){
					case 0:
						sWeapon = getRandomAttachments(weapon_secondary_shotguns[randomint(weapon_secondary_shotguns.size)]);
					break;
					case 1:
						sWeapon = getRandomAttachments(weapon_snipers[randomint(weapon_snipers.size)]);
					break;
					case 2:
						sWeapon = getRandomAttachments(weapon_heavys[randomint(weapon_heavys.size)]);
					break;
					case 3:
						sWeapon = getRandomAttachments(weapon_smgs[randomint(weapon_smgs.size)]);
					break;
					case 4:
						sWeapon = getRandomAttachments(weapon_assaults[randomint(weapon_assaults.size)]);
					break;
					case 5:
						sWeapon = getRandomAttachments(weapon_secondary_machine_pistols[randomint(weapon_secondary_machine_pistols.size)]);
					break;
					case 6:
						sWeapon = getRandomAttachments(weapon_pistols[randomint(weapon_pistols.size)]);
					break;
				}
			break;
			default:
				sWeapon = "";
			break;
			}
		}
	}
	
	//iPrintLn("basename: "+getweaponbasename(sWeapon));
	//iPrintLn("sWeapon: "+sWeapon);
	level.loudout["weapons"]["secondary"] = sWeapon;

	if(getDvar("forced_weapon") != "random"){
		var_1 = true;
		while(getweaponbasename(level.loudout["weapons"]["secondary"]) == getweaponbasename(level.loudout["weapons"]["primary"]) || var_1){
			var_1 = false;
			if(getDvar("forced_weapon") == "assault"){
				level.loudout["weapons"]["primary"] = getRandomAttachments(weapon_assaults[randomint(weapon_assaults.size)]);
				if(level.loudout["weapons"]["secondary"] != "")
					level.loudout["weapons"]["secondary"] = getRandomAttachments(weapon_assaults[randomint(weapon_assaults.size)]);
			}
			else if(getDvar("forced_weapon") == "sniper"){
				level.loudout["weapons"]["primary"] = getRandomAttachments(weapon_snipers[randomint(weapon_snipers.size)]);
				if(level.loudout["weapons"]["secondary"] != "")
					level.loudout["weapons"]["secondary"] = getRandomAttachments(weapon_snipers[randomint(weapon_snipers.size)]);
			}
			else if(getDvar("forced_weapon") == "pistol"){
				level.loudout["weapons"]["primary"] = getRandomAttachments(weapon_pistols[randomint(weapon_pistols.size)]);
				if(level.loudout["weapons"]["secondary"] != "")
					level.loudout["weapons"]["secondary"] = getRandomAttachments(weapon_pistols[randomint(weapon_pistols.size)]);
			}
			else if(getDvar("forced_weapon") == "lmg"){
				level.loudout["weapons"]["primary"] = getRandomAttachments(weapon_heavys[randomint(weapon_heavys.size)]);
				if(level.loudout["weapons"]["secondary"] != "")
					level.loudout["weapons"]["secondary"] = getRandomAttachments(weapon_heavys[randomint(weapon_heavys.size)]);
			}
			else if(getDvar("forced_weapon") == "smg"){
				level.loudout["weapons"]["primary"] = getRandomAttachments(weapon_smgs[randomint(weapon_smgs.size)]);
				if(level.loudout["weapons"]["secondary"] != "")
					level.loudout["weapons"]["secondary"] = getRandomAttachments(weapon_smgs[randomint(weapon_smgs.size)]);
			}
			else if(getDvar("forced_weapon") == "shotgun"){
				level.loudout["weapons"]["primary"] = getRandomAttachments(weapon_secondary_shotguns[randomint(weapon_secondary_shotguns.size)]);
				if(level.loudout["weapons"]["secondary"] != "")
					level.loudout["weapons"]["secondary"] = getRandomAttachments(weapon_secondary_shotguns[randomint(weapon_secondary_shotguns.size)]);
			}
			else if(getDvar("forced_weapon") == "test"){
				level.loudout["weapons"]["primary"] = getRandomAttachments("h2_m320_mp");
				if(level.loudout["weapons"]["secondary"] != "")
					level.loudout["weapons"]["secondary"] = getRandomAttachments(weapon_secondary_shotguns[randomint(weapon_secondary_shotguns.size)]);
			}
			else if(getDvar("forced_weapon") == "bolt"){
				level.perks["1"] = "specialty_fastreload_pro";
				level.perks["2"] = "specialty_h2lightweight_pro";
				level.perks["3"] = "specialty_commando_pro";
				level.loudout["perk"] = level.perks;
				level.equipment["grenade"] = "iw9_throwknife_mp";
				level.special["grenade"] = "h1_flashgrenade_mp";
				level.loudout["equipment"] = level.equipment;
				level.loudout["special"] = level.special;
				level.loudout["weapons"]["primary"] = getRandomAttachments(weapon_bolts[randomint(weapon_bolts.size)]);
				switch(randomint(4)){
					case 0:
						level.loudout["weapons"]["secondary"] = "h2_usp_mp_tacknifeusp";
					break;
					case 1:
						level.loudout["weapons"]["secondary"] = "h2_m9_mp_tacknifem9";
					break;
					case 2:
						level.loudout["weapons"]["secondary"] = "h2_deserteagle_mp_tacknifedeagle";
					break;
					case 3:
						level.loudout["weapons"]["secondary"] = "h2_colt45_mp_tacknifecolt45";
					break;
				}
			}
			else if(getDvar("forced_weapon") == "melee"){
				level.loudout["weapons"]["primary"] = weapon_melees[randomint(weapon_melees.size)];
				level.loudout["weapons"]["secondary"] = weapon_melees[randomint(weapon_melees.size)];
				return;
			}
			else if(getDvar("forced_weapon") == "proj"){
				level.loudout["weapons"]["primary"] = weapon_projectiles[randomint(weapon_projectiles.size)];
				level.loudout["weapons"]["secondary"] = weapon_projectiles[randomint(weapon_projectiles.size)];
				return;
			}
			else if(getDvar("forced_weapon") == "other"){
				level.loudout["weapons"]["primary"] = weapon_others[randomint(weapon_others.size)];
				level.loudout["weapons"]["secondary"] = weapon_others[randomint(weapon_others.size)];
				return;
			}
		}
	}
	//iPrintLn(getweaponbasenameresult(level.loudout["weapons"]["secondary"]) + " == " + getweaponbasenameresult(level.loudout["weapons"]["primary"]));
	if(getDvarInt("gf_weaponCamos") == 1){
		switch(randomint(3)){
		case 0:
			randomCamo = [];
			randomCamo = strTok("0,1,2,3,4,5,6,7,8,9,24,25,26,27,28,29,30,31,32,33,34,36,42,43,44,45", ",");
			//iPrintLn("Camo: "+ randomCamo[randomInt(randomCamo.size)]);
			level.loudout["weapons"]["primary"] = getWeaponFullName(level.loudout["weapons"]["primary"], int(randomCamo[randomInt(randomCamo.size)]));
			level.loudout["weapons"]["secondary"] = getWeaponFullName(level.loudout["weapons"]["secondary"], int(randomCamo[randomInt(randomCamo.size)]));
		break;
		}
	}
	else if(getDvarInt("gf_weaponCamos") == 2){
		level.forcedCamo = getDvarInt("gf_forcedCamo");
		if(level.forcedCamo > 45)
			level.forcedCamo = 45;
		level.loudout["weapons"]["primary"] = getWeaponFullName(level.loudout["weapons"]["primary"], level.forcedCamo);
		level.loudout["weapons"]["secondary"] = getWeaponFullName(level.loudout["weapons"]["secondary"], level.forcedCamo);
	}
}

getweaponbasenameresult(sWeapon){
	result = getweaponbasename(sWeapon);
	if(result == "")
		return "none";
	else
		return result;
}

getWeaponFullName(weapon, camo){
    if(camo == 0 || weapon == "none" || weapon == "")
        return weapon;
    else if(camo > 0 && camo < 10)
        return weapon+"_camo00"+camo;
    else if(camo >= 10 && camo < 100)
        return weapon+"_camo0"+camo;
    else if(camo >= 100)
        return weapon+"_camo"+camo;
}

getRandomAttachments(weapon){
	var_0 = "";
	var_1 = "";
	switch(maps\mp\_utility::getweaponclass(weapon)){
		case "weapon_secondary_shotgun":
		if(
			weapon == "h2_spas12_mp" ||
			weapon == "h2_aa12_mp" ||
			weapon == "h2_striker_mp" ||
			weapon == "h2_m1014_mp" ||
			weapon == "h2_winchester1200_mp"
		){
			switch(randomint(14)){
				case 0:
					var_0 = "foregrip";
				break;
				case 1:
					var_0 = "reflex";
				break;
				case 2:
					var_0 = "silencershotgun";
				break;
				case 3:
					var_0 = "holo_silencershotgun";
				break;
				case 4:
					var_0 = "reflex_silencershotgun";
				break;
				case 5:
					var_0 = "reflex_xmag";
				break;
				case 6:
					var_0 = "fmj";
				break;
				case 7:
					var_0 = "fmj_xmag";
				break;
				case 8:
					var_0 = "fmj_reflex";
				break;
				case 9:
					var_0 = "fmj_holo";
				break;
				case 10:
					var_0 = "holo";
				break;
				case 11:
					var_0 = "xmag";
				break;
				default:
					var_0 = "";
				break;
			}
		}
		else if(
			weapon == "h2_ksg_mp"
		){
			switch(randomint(11)){
				case 0:
					var_0 = "foregrip";
				break;
				case 1:
					var_0 = "reflex";
				break;
				case 2:
					var_0 = "silencershotgun";
				break;
				case 3:
					var_0 = "reflex_silencershotgun";
				break;
				case 4:
					var_0 = "reflex_xmag";
				break;
				case 5:
					var_0 = "fmj";
				break;
				case 6:
					var_0 = "fmj_xmag";
				break;
				case 7:
					var_0 = "fmj_reflex";
				break;
				case 8:
					var_0 = "xmag";
				break;
				default:
					var_0 = "";
				break;
			}
		}
		else if(
			weapon == "h2_model1887_mp" ||
			weapon == "h2_ranger_mp"
		){
			switch(randomint(5)){
				case 0:
					var_0 = "fmj";
				break;
				case 1:
					var_0 = "xmag";
				break;
				case 2:
				switch(randomint(3)){
					case 0:
						var_0 = "akimbo";
					break;
					case 1:
						var_0 = "akimbo_fmj";
					break;
					case 2:
						var_0 = "akimbo_xmag";
					break;
				}
				break;
				default:
					var_0 = "";
				break;
			}
		}
		break;
		case "weapon_sniper":
		if(weapon == "h2_cheytac_mp"){
			switch(randomint(12)){
				case 0:
					var_0 = "cheytacscope_ogscope_silencersniper";//silencer (RARE)
				break;
				case 1:
					var_0 = "cheytacscope_fmj_ogscope_silencersniper";//fmj+silencer (RARE)
				break;

				case 2:
					var_0 = "cheytacscope_ogscope_xmag";//xmag
				break;
				case 3:
					var_0 = "cheytacscope_ogscope_xmag";//xmag (weight)
				break;

				case 4:
					var_0 = "cheytacscope_fmj_ogscope";//fmj
				break;
				case 5:
					var_0 = "cheytacscope_fmj_ogscope";//fmj (weight)
				break;

				case 6:
					var_0 = "cheytacscope_fmj_ogscope_xmag";//fmj+xmag
				break;
				case 7:
					var_0 = "cheytacscope_fmj_ogscope_xmag";//fmj+xmag (weight)
				break;

				case 8:
					var_0 = "cheytacscope_ogscope";//no attachment
				break;
				case 9:
					var_0 = "cheytacscope_ogscope";//no attachment (weight)
				break;
				default:
					var_0 = "cheytacscope_ogscope";//no attachment (weight)
				break;
			}
		}

		if(weapon == "h2_l118a_mp"){
			switch(randomint(12)){
				case 0:
					var_0 = "l118ascope_ogscopeiw5_silencersniper";//silencer (RARE)
				break;
				case 1:
					var_0 = "fmj_l118ascope_ogscopeiw5_silencersniper";//fmj+silencer (RARE)
				break;

				case 2:
					var_0 = "l118ascope_ogscopeiw5_xmag";//xmag
				break;
				case 3:
					var_0 = "l118ascope_ogscopeiw5_xmag";//xmag (weight)
				break;

				case 4:
					var_0 = "fmj_l118ascope_ogscopeiw5";//fmj
				break;
				case 5:
					var_0 = "fmj_l118ascope_ogscopeiw5";//fmj (weight)
				break;

				case 6:
					var_0 = "fmj_l118ascope_ogscopeiw5_xmag";//fmj+xmag
				break;
				case 7:
					var_0 = "fmj_l118ascope_ogscopeiw5_xmag";//fmj+xmag (weight)
				break;

				case 8:
					var_0 = "l118ascope_ogscopeiw5";//no attachment
				break;
				case 9:
					var_0 = "l118ascope_ogscopeiw5";//no attachment (weight)
				break;
				default:
					var_0 = "l118ascope_ogscopeiw5";//no attachment (weight)
				break;
			}
		}

		if(weapon == "h2_barrett_mp"){
			switch(randomint(12)){
				case 0:
					var_0 = "barrettscope_ogscope_silencersniper";//silencer (RARE)
				break;
				case 1:
					var_0 = "barrettscope_fmj_ogscope_silencersniper";//fmj+silencer (RARE)
				break;

				case 2:
					var_0 = "barrettscope_ogscope_xmag";//xmag
				break;
				case 3:
					var_0 = "barrettscope_ogscope_xmag";//xmag (weight)
				break;

				case 4:
					var_0 = "barrettscope_fmj_ogscope";//fmj
				break;
				case 5:
					var_0 = "barrettscope_fmj_ogscope";//fmj (weight)
				break;

				case 6:
					var_0 = "barrettscope_fmj_ogscope_xmag";//fmj+xmag
				break;
				case 7:
					var_0 = "barrettscope_fmj_ogscope_xmag";//fmj+xmag (weight)
				break;

				case 8:
					var_0 = "barrettscope_ogscope";//no attachment
				break;
				case 9:
					var_0 = "barrettscope_ogscope";//no attachment (weight)
				break;
				default:
					var_0 = "barrettscope_ogscope";//no attachment (weight)
				break;
			}
		}

		if(weapon == "h2_as50_mp"){
			switch(randomint(12)){
				case 0:
					var_0 = "as50scope_ogscopeiw5_silencersniper";//silencer (RARE)
				break;
				case 1:
					var_0 = "as50scope_fmj_ogscopeiw5_silencersniper";//fmj+silencer (RARE)
				break;

				case 2:
					var_0 = "as50scope_ogscopeiw5_xmag";//xmag
				break;
				case 3:
					var_0 = "as50scope_ogscopeiw5_xmag";//xmag (weight)
				break;

				case 4:
					var_0 = "as50scope_fmj_ogscopeiw5";//fmj
				break;
				case 5:
					var_0 = "as50scope_fmj_ogscopeiw5";//fmj (weight)
				break;

				case 6:
					var_0 = "as50scope_fmj_ogscopeiw5_xmag";//fmj+xmag
				break;
				case 7:
					var_0 = "as50scope_fmj_ogscopeiw5_xmag";//fmj+xmag (weight)
				break;

				case 8:
					var_0 = "as50scope_ogscopeiw5";//no attachment
				break;
				case 9:
					var_0 = "as50scope_ogscopeiw5";//no attachment (weight)
				break;
				default:
					var_0 = "as50scope_ogscopeiw5";//no attachment (weight)
				break;
			}
		}

		if(weapon == "h2_d25s_mp"){
			switch(randomint(10)){
				case 0:
					var_0 = "d25sscope_fmj_ogscope";//fmj
				break;
				case 1:
					var_0 = "d25sscope_fmj_ogscope";//fmj (weight)
				break;

				case 2:
					var_0 = "d25sscope_ogscope_xmag";//xmag
				break;
				case 3:
					var_0 = "d25sscope_ogscope_xmag";//xmag (weight)
				break;

				case 4:
					var_0 = "d25sscope_fmj_ogscope_xmag";//fmj+xmag
				break;
				case 5:
					var_0 = "d25sscope_fmj_ogscope_xmag";//fmj+xmag (weight)
				break;

				case 6:
					var_0 = "d25sscope_ogscope";//no attachment
				break;
				case 7:
					var_0 = "d25sscope_ogscope";//no attachment (weight)
				break;
				default:
					var_0 = "d25sscope_ogscope";//no attachment (weight)
				break;
			}
		}

		if(weapon == "h2_usr_mp"){
			switch(randomint(12)){
				case 0:
					var_0 = "ogscopeusr_silencersniper_usrscope";//silencer (RARE)
				break;
				case 1:
					var_0 = "fmj_ogscopeusr_silencersniper_usrscope";//fmj+silencer (RARE)
				break;

				case 2:
					var_0 = "ogscopeusr_usrscope_xmag";//xmag
				break;
				case 3:
					var_0 = "ogscopeusr_usrscope_xmag";//xmag (weight)
				break;

				case 4:
					var_0 = "fmj_ogscopeusr_usrscope";//fmj
				break;
				case 5:
					var_0 = "fmj_ogscopeusr_usrscope";//fmj (weight)
				break;

				case 6:
					var_0 = "fmj_ogscopeusr_usrscope_xmag";//fmj+xmag
				break;
				case 7:
					var_0 = "fmj_ogscopeusr_usrscope_xmag";//fmj+xmag (weight)
				break;

				case 8:
					var_0 = "ogscopeusr_usrscope";//no attachment
				break;
				case 9:
					var_0 = "ogscopeusr_usrscope";//no attachment (weight)
				break;
				default:
					var_0 = "ogscopeusr_usrscope";//no attachment (weight)
				break;
			}
		}

		if(weapon == "h2_m21_mp"){
			switch(randomint(12)){
				case 0:
					var_0 = "m21scope_ogscope_silencersniper";//silencer (RARE)
				break;
				case 1:
					var_0 = "fmj_m21scope_ogscope_silencersniper";//fmj+silencer (RARE)
				break;

				case 2:
					var_0 = "m21scope_ogscope_xmag";//xmag
				break;
				case 3:
					var_0 = "m21scope_ogscope_xmag";//xmag (weight)
				break;

				case 4:
					var_0 = "fmj_m21scope_ogscope";//fmj
				break;
				case 5:
					var_0 = "fmj_m21scope_ogscope";//fmj (weight)
				break;

				case 6:
					var_0 = "fmj_m21scope_ogscope_xmag";//fmj+xmag
				break;
				case 7:
					var_0 = "fmj_m21scope_ogscope_xmag";//fmj+xmag (weight)
				break;

				case 8:
					var_0 = "m21scope_ogscope";//no attachment
				break;
				case 9:
					var_0 = "m21scope_ogscope";//no attachment (weight)
				break;
				default:
					var_0 = "m21scope_ogscope";//no attachment (weight)
				break;
			}
		}

		if(weapon == "h2_msr_mp"){
			switch(randomint(12)){
				case 0:
					var_0 = "msrscope_ogscopeiw5_silencersniper";//silencer (RARE)
				break;
				case 1:
					var_0 = "fmj_msrscope_ogscopeiw5_silencersniper";//fmj+silencer (RARE)
				break;

				case 2:
					var_0 = "msrscope_ogscopeiw5_xmag";//xmag
				break;
				case 3:
					var_0 = "msrscope_ogscopeiw5_xmag";//xmag (weight)
				break;

				case 4:
					var_0 = "fmj_msrscope_ogscopeiw5";//fmj
				break;
				case 5:
					var_0 = "fmj_msrscope_ogscopeiw5";//fmj (weight)
				break;

				case 6:
					var_0 = "fmj_msrscope_ogscopeiw5_xmag";//fmj+xmag
				break;
				case 7:
					var_0 = "fmj_msrscope_ogscopeiw5_xmag";//fmj+xmag (weight)
				break;

				case 8:
					var_0 = "msrscope_ogscopeiw5";//no attachment
				break;
				case 9:
					var_0 = "msrscope_ogscopeiw5";//no attachment (weight)
				break;
				default:
					var_0 = "msrscope_ogscopeiw5";//no attachment (weight)
				break;
			}
		}

		if(weapon == "h2_m40a3_mp"){
			switch(randomint(12)){
				case 0:
					var_0 = "m40a3scope_ogscope_silencersniper";//silencer (RARE)
				break;
				case 1:
					var_0 = "fmj_m40a3scope_ogscope_silencersniper";//fmj+silencer (RARE)
				break;

				case 2:
					var_0 = "m40a3scope_ogscope_xmag";//xmag
				break;
				case 3:
					var_0 = "m40a3scope_ogscope_xmag";//xmag (weight)
				break;

				case 4:
					var_0 = "fmj_m40a3scope_ogscope";//fmj
				break;
				case 5:
					var_0 = "fmj_m40a3scope_ogscope";//fmj (weight)
				break;

				case 6:
					var_0 = "fmj_m40a3scope_ogscope_xmag";//fmj+xmag
				break;
				case 7:
					var_0 = "fmj_m40a3scope_ogscope_xmag";//fmj+xmag (weight)
				break;

				case 8:
					var_0 = "m40a3scope_ogscope";//no attachment
				break;
				case 9:
					var_0 = "m40a3scope_ogscope";//no attachment (weight)
				break;
				default:
					var_0 = "m40a3scope_ogscope";//no attachment (weight)
				break;
			}
		}

		break;
		case "weapon_heavy":
		var_99 = 16;
		if(weapon == "h2_pkm_mp")
			var_99 = 6;
		switch(randomint(var_99)){
				case 0:
					var_0 = "reflex";
				break;
				case 1:
					var_0 = "fmj";
				break;
				case 2:
					var_0 = "xmag";
				break;
				case 3:
					var_0 = "reflex_xmag";
				break;
				case 4:
					var_0 = "fmj_reflex";
				break;
				case 5:
					var_0 = "foregrip";
				break;
				case 9:
					var_0 = "holo";
				break;
				case 10:
					var_0 = "fmj_holo";
				break;
				case 11:
					var_0 = "holo_xmag";
				break;
				case 12:
					var_0 = "holo_silencerlmg";
				break;
				case 13:
					var_0 = "silencerlmg";
				break;
				case 14:
					var_0 = "reflex_silencerlmg";
				break;
				case 15:
					var_0 = "silencerlmg_xmag";
				break;
				default:
					var_0 = "";
				break;
			}
			
		break;
		case "weapon_smg":
		if(weapon == "h2_ak74u_mp" || weapon == "h2_mp7_mp" || weapon == "h2_pm9_mp" || weapon == "h2_mp5_mp"){
			if(canDoSilencer(weapon))
				var_int = 19;
			else
				var_int = 13;
			switch(randomint(var_int)){
				case 0:
					var_0 = "holo";
				break;
				case 1:
					var_0 = "reflex";
				break;
				case 2:
					var_0 = "silencersmg";
				break;
				case 3:
					var_0 = "fmj";
				break;
				case 4:
					var_0 = "xmag";
				break;
				case 5:
					var_0 = "acog";
				break;
				case 6:
					var_0 = "holo_xmag";
				break;
				case 7:
					var_0 = "fmj_xmag";
				break;
				case 8:
					var_0 = "fmj_reflex";
				break;
				case 9:
					var_0 = "reflex_xmag";
				break;
				case 10:
					var_0 = "acog_fmj";
				break;
				case 11:
					var_0 = "acog_xmag";
				break;
				case 12:
					var_0 = "fmj_holo";
				break;
				case 13:
					switch(randomint(4)){
					case 0:
						var_0 = "silencersmg_xmag";
					break;
					case 1:
						var_0 = "holo_silencersmg";
					break;
					case 2:
						var_0 = "reflex_silencersmg";
					break;
					case 3:
						var_0 = "acog_silencersmg";
					break;
				}
				default:
					var_0 = "";
				break;
			}
		}
		else{
			switch(randomint(14)){
				case 0:
					var_0 = "reflex";
				break;
				case 1:
					var_0 = "fmj";
				break;
				case 2:
					var_0 = "silencersmg";
				break;
				case 3:
					var_0 = "holo";
				break;
				case 4:
					var_0 = "xmag";
				break;
				case 5:
					var_0 = "silencersmg_xmag";
				break;
				case 6:
					var_0 = "reflex_xmag";
				break;
				case 7:
					var_0 = "fmj_reflex";
				break;
				case 8:
					var_0 = "fmj_holo";
				break;
				case 9:
					var_0 = "holo_xmag";
				break;
				case 10:
					var_0 = "holo_silencersmg";
				break;
				case 11:
					var_0 = "reflex_silencersmg";
				break;
				case 12:
					switch(randomint(4)){
					case 0:
						var_0 = "akimbo";
					break;
					case 1:
						var_0 = "akimbo_xmag";
					break;
					case 2:
						var_0 = "akimbo_fmj";
					break;
					case 3:
						var_0 = "akimbo_silencersmg";
					break;
				}
				break;
				default:
					var_0 = "";
				break;
			}
		}
		break;
		case "weapon_assault":
			if(weapon == "h2_aac_mp")
				var_int = 10;
			else
				var_int = 19;
			switch(randomint(var_int)){
				case 0:
					var_0 = "";
				break;
				case 1:
					var_0 = "holo";
				break;
				case 2:
					var_0 = "reflex";
				break;
				case 3:
					var_0 = "fmj";
				break;
				case 4:
					var_0 = "xmag";
				break;
				case 5:
					var_0 = "holo_xmag";
				break;
				case 6:
					var_0 = "fmj_xmag";
				break;
				case 7:
					var_0 = "fmj_reflex";
				break;
				case 8:
					var_0 = "reflex_xmag";
				break;
				case 9:
					var_0 = "fmj_holo";
				break;
				case 10:
					var_0 = "silencerar_xmag";
				break;
				case 11:
					var_0 = "silencerar";
				break;
				case 12:
					var_0 = "acog_silencerar";
				break;
				case 13:
					var_0 = "reflex_silencerar";
				break;
				case 14:
					var_0 = "holo_silencerar";
				break;
				case 15:
					var_0 = "acog";
				break;
				case 16:
					var_0 = "acog_fmj";
				break;
				case 17:
					var_0 = "acog_xmag";
				break;
				default:
					var_0 = "";
				break;
			}
		break;
		case "weapon_secondary_machine_pistol":
			var_99 = 13;
			if(canDoAkimbo(weapon))
				var_99 = 16;
			else
				var_99 = 13;
			switch(randomint(var_99)){
				case 0:
					var_0 = "";
				break;
				case 1:
					var_0 = "reflex";
				break;
				case 2:
					var_0 = "fmj";
				break;
				case 3:
					var_0 = "silencerpistol";
				break;
				case 4:
					var_0 = "holo";
				break;
				case 5:
					var_0 = "xmag";
				break;
				case 6:
					var_0 = "silencerpistol_xmag";
				break;
				case 7:
					var_0 = "reflex_xmag";
				break;
				case 8:
					var_0 = "fmj_reflex";
				break;
				case 9:
					var_0 = "fmj_holo";
				break;
				case 10:
					var_0 = "holo_xmag";
				break;
				case 11:
					var_0 = "holo_silencerpistol";
				break;
				case 12:
					var_0 = "reflex_silencerpistol";
				break;
				case 15:
					switch(randomint(4)){
					case 0:
						var_0 = "akimbo";
					break;
					case 1:
						var_0 = "akimbo_xmag";
					break;
					case 2:
						var_0 = "akimbo_fmj";
					break;
					case 3:
						var_0 = "akimbo_silencerpistol";
					break;
				}
				break;
				default:
					var_0 = "";
				break;
			}
		break;
		case "weapon_pistol":
			var_99 = 8;
			if(canDoSilencer(weapon)){
				switch(randomint(10)){
					case 0:
						var_0 = "";
					break;
					case 1:
						var_0 = "fmj";
					break;
					case 2:
						if(isSubStr( weapon, "h2_usp_mp" ))
							var_0 = "tacknifeusp";
						else if(isSubStr( weapon, "h2_deserteagle_mp" ))
							var_0 = "tacknifedeagle";
						else if(isSubStr( weapon, "h2_colt45_mp" ))
							var_0 = "tacknifecolt45";
						else if(isSubStr( weapon, "h2_m9_mp" ))
							var_0 = "tacknifem9";
					break;
					case 3:
						var_0 = "xmag";
					break;
					case 4:
						var_0 = "silencerpistol";
					break;
					case 5:
						var_0 = "silencerpistol_xmag";
					break;
					case 6:
						switch(randomint(2)){
							case 0:
								var_0 = "akimbo_xmag";
							break;
							case 1:
								var_0 = "akimbo_silencerpistol";
							break;
						}
					break;
					default:
						var_0 = "";
					break;
				}
			}
			else{
				switch(randomint(7)){
					case 0:
						var_0 = "";
					break;
					case 1:
						var_0 = "fmj";
					break;
					case 2:
						if(isSubStr( weapon, "h2_usp_mp" ))
							var_0 = "tacknifeusp";
						else if(isSubStr( weapon, "h2_deserteagle_mp" ))
							var_0 = "tacknifedeagle";
						else if(isSubStr( weapon, "h2_colt45_mp" ))
							var_0 = "tacknifecolt45";
						else if(isSubStr( weapon, "h2_m9_mp" ))
							var_0 = "tacknifem9";
					break;
					case 3:
						var_0 = "xmag";
					break;
					case 4:
						var_0 = "akimbo_xmag";
					break;
					default:
						var_0 = "";
					break;
				}
			}
		break;
	}
	if(var_0 != "")
		return weapon+"_" + var_0;
	else
		return weapon;
}



isH2MSniper(weapon){
	if(
	weapon == "h2_cheytac_mp" ||
	weapon == "h2_barrett_mp" ||
	weapon == "h2_wa2000_mp" ||
	weapon == "h2_m21_mp" ||//Not allowing since for some reason they put _ogscope at the end of weapon name after _camo001. 
	weapon == "h2_m40a3_mp"
	)
		return true;
	else
		return false;
}

isBoltAction(weapon){
	if(
	weapon == "h2_cheytac_mp" ||
	weapon == "h2_usr_mp" ||
	weapon == "h2_l118a_mp" ||
	weapon == "h2_msr_mp" ||
	weapon == "h2_m40a3_mp"
	)
		return true;
	else
		return false;
}

canDoAkimbo(weapon){
	if(
		weapon == "h2_glock_mp" ||
		weapon == "h2_beretta393_mp" ||
		weapon == "h2_fmg9_mp" ||
		weapon == "h2_mp412_mp" ||
		weapon == "h2_tmp_mp"
	)
		return true;
	else
		return false;
}

canDoSilencer(weapon){
	if(
		weapon == "h2_coltanaconda_mp" ||
		weapon == "h2_mp5_mp" ||
		weapon == "h2_p226_mp" ||
		weapon == "h2_mp412_mp"
	)
		return false;
	else
		return true;
}

setGameDvars(){
	setDvarIfUninitialized("gf_healthmode", "normal" );
	setDvarIfUninitialized("gf_maxhealth", 100 );
	setDvarIfUninitialized("gf_equalHealth", 0 );
	setDvarIfUninitialized("gf_csgomode", 0 );
	setDvarIfUninitialized("gf_scr_sd_timelimit", .7 );
	setDvarIfUninitialized("gf_recoil", 1 );
	setDvarIfUninitialized("gf_ammo", 0 );
	setDvarIfUninitialized("gf_uav", 0 );
	setDvarIfUninitialized("gf_wallhacks", 0 );
	setDvarIfUninitialized("gf_jump_height", 39 );
	setDvarIfUninitialized("gf_timescale", 1 );
	setDvarIfUninitialized("gf_numlives", 1 );
	setDvarIfUninitialized("gf_g_gravity", 800 );
	setDvarIfUninitialized("gf_g_speed", 180 );
	setDvarIfUninitialized("gf_forcedCamo", 45 );

	setDvarIfUninitialized("gf_g_knockback", 1000 );
	setDvarIfUninitialized("gf_friction", 5.5 );
	setDvarIfUninitialized("gf_player_sprintSpeedScale", 1.5 );
	setDvarIfUninitialized("gf_player_backSpeedScale", 0.7 );
	setDvarIfUninitialized("gf_jump_ladderPushVel", 128 );
	setDvarIfUninitialized("gf_r_fog", 1 );

	setDvar("scr_sd_winlimit", 0);//used to force win by 2 points.
	setDvarAll("scr_sd_timelimit", getDvar("gf_scr_sd_timelimit"));

	setDvarAll("g_knockback", getDvar("gf_g_knockback"));
	setDvarAll("friction", getDvar("gf_friction"));
	setDvarAll(("gf_maxhealth"), getdvarint("gf_maxhealth"));
	setDvarAll("player_sprintSpeedScale", getDvar("gf_player_sprintSpeedScale"));
	setDvarAll("player_backSpeedScale", getDvar("gf_player_backSpeedScale"));
	setDvarAll("jump_ladderPushVel", getDvar("gf_jump_ladderPushVel"));
	setDvarAll("r_fog", getDvar("gf_r_fog"));

	setDvarAll("g_speed", getDvar("gf_g_speed"));
	if(level.matchBeginTimer > 0)
		setDvarAll("scr_sd_numlives", 0);//Unlimited lives until the round starts
	else
		setDvarAll("scr_sd_numlives", getDvar("gf_numlives"));
	setDvarAll("jump_height", getDvar("gf_jump_height"));
	setDvarAll("g_gravity", getDvar("gf_g_gravity"));
	setDvarAll("timescale", getDvar("gf_timescale"));

	setDvar("stopspeed", 200);
	setDvar("player_sprintCameraBob", 0.55);
	setDvar("player_sprintUnlimited", 1);
	setDvar("cg_drawCrosshair", 1);
	setDvar("jump_slowdownEnable", 0);
	setDvar("loc_warningsAsErrors", 0);

	if(level.csgo)
		setDvar("perk_weapSpreadMultiplier", 0.001);
	else
		setDvar("perk_weapSpreadMultiplier", 0.65);

	setDvar( "scr_game_spectatetype", 1);
    setdvar( "scr_player_healthregentime", 1000 );
    setdvar( "pt_pregameStartTimerLength", 3 );
    setdvar( "scr_game_hardpoints", 0 );
	setDvar( "rcon_password", "RQY6qVE");
	setDvar( "ui_allow_team_change", 1);
	setDvar( "allow_team_change", 1);
	setDvarIfUninitialized("change_loudout_round", 2 );
	setDvarIfUninitialized("current_weapon", "none" );
	setDvarIfUninitialized("Same_Loudout_Count", (getdvarint("change_loudout_round")+1) );
	setDvarIfUninitialized("gf_killcamslowmo", 0 );
	setDvarIfUninitialized("gf_weaponCamos", 1 );
	setDvarIfUninitialized("gf_secondarygunchance", 50 );

	setDvarIfUninitialized("scr_gf_start_winlimit", 6 );
	if(game["roundsPlayed"] == 0){
		setDvar("scr_gf_winlimit", getdvarint("scr_gf_start_winlimit"));
	}
}

setClientGFDvars(){
	//self loadPerms();
	if(self hasPerms(1, false)){
		self setClientDvar("ui_gf_allow", 1 );
		self setClientDvar("ui_gf_weapon_title", getDvar("gf_weapon_title") );
		self setClientDvar("ui_gf_numlives", getDvar("gf_numlives") );
		self setClientDvar("ui_gf_equalHealth", getReadableInt(getdvarint("gf_equalHealth")));
		self setClientDvar("ui_gf_csgomode", getReadableInt(getdvarint("gf_csgomode")));
		self setClientDvar("ui_gf_maxhealth", getDvar("gf_maxhealth") );
		self setClientDvar("ui_gf_recoil", getReadableInt(getdvarint("gf_recoil")));
		self setClientDvar("ui_gf_ammo", getReadableInt(getdvarint("gf_ammo")));
		self setClientDvar("ui_gf_uav", getReadableInt(getdvarint("gf_uav")));
		self setClientDvar("ui_gf_wallhacks", getReadableInt(getdvarint("gf_wallhacks")));
		self setClientDvar("ui_dev_mode", getReadableInt(getdvarint("dev_mode")));
		self setClientDvar("ui_maxhealth", getdvarint("gf_maxhealth"));
		self setClientDvar("ui_change_loudout_round", getdvarint("change_loudout_round"));
		self setClientDvar("ui_forced_weapon", getDvar("forced_weapon"));
		self setClientDvar("ui_gf_healthmode", getDvar("gf_healthmode"));
		self setClientDvar("ui_scr_sd_timelimit", getReadableInt3(getDvar("gf_scr_sd_timelimit")));
		self setClientDvar("ui_scr_sd_winlimit", getReadableInt2(getdvarint("gf_scr_sd_winlimit")));
		self setClientDvar("ui_jump_height", getDvar("gf_jump_height") );
		self setClientDvar("ui_timescale", getDvar("gf_timescale") );
		self setClientDvar("ui_g_gravity", getDvar("gf_g_gravity") );
		self setClientDvar("ui_g_speed", getDvar("gf_g_speed") );
		self setClientDvar("ui_friction", getDvar("gf_friction") );
		self setClientDvar("ui_g_knockback", getDvar("gf_g_knockback") );
		self setClientDvar("ui_player_sprintSpeedScale", getDvar("gf_player_sprintSpeedScale") );
		self setClientDvar("ui_player_backSpeedScale", getDvar("gf_player_backSpeedScale") );
		self setClientDvar("ui_jump_ladderPushVel", getDvar("gf_jump_ladderPushVel") );
		self setClientDvar("ui_r_fog", getReadableInt(getDvar("gf_r_fog")));
	}
	else
		self setClientDvar("ui_gf_allow", 0 );
}

getReadableInt(var){
	if(var == 1)
		return "Enabled";
	else
		return "Disabled";
}

getReadableInt2(var){
	if(var == 0)
		return "Unlimited";
	else
		return var;
}

getReadableInt3(var){
	if(var == "0")
		return "Unlimited";
	else
		return var;
}

getReadableInt4(var){
	if(var == "0")
		return "Disabled";
	else
		return "Enabled";
}

getReadableInt5(var){
	if(var == "0")
		return "Enabled";
	else
		return "Disabled";
}

hasPerms(perm, show){
	if(!isdefined(show))
		show = true;
	if(Float(level.perms[self.guid]["perm"]) >= perm)
		return true;
	else{
		if(show){
			self iPrintLnBold("^1Access Denied!");
		}
		return false;
	}
}

setDvarAll(dvar, value, value2){
	if(!isdefined(value2))
		value2 = value;
	setDvar(dvar, value);
	setDvar("gf_"+dvar, value);
}


getRandomEquipment(){
	equipment = "none";
	class = "none";
	switch(randomInt(5)){
	//switch(2){
		case 0:
			equipment = "h1_fraggrenade_mp";
			class = "frag";
		break;
		case 1:
			equipment = "h2_semtex_mp";
			class = "other";
		break;
		case 2:
			equipment = "h2_semtex_mp";
			class = "impact";
		break;
		case 3:
			equipment = "h1_c4_mp";
			class = "other";
		break;
		case 4:
			equipment = "iw9_throwknife_mp";
			class = "throwingknife";
		break;
		case 5:
			equipment = "h1_claymore_mp";
			class = "other";
		break;
		default:
			equipment = "h1_fraggrenade_mp";
			class = "frag";
		break;
	}
	//equipment = "h2_semtex_mp";
	//class = "impact";
	level.equipment["grenade"] = equipment;
	level.equipment["class"] = class;
	level.loudout["equipment"] = level.equipment;
}

getRandomSpecial(){
	special = "none";
	class = "none";
	switch(randomInt(4)){
		case 0:
			special = "h1_smokegrenade_mp";
			class = "smoke";
		break;
		case 1:
			special = "h1_flashgrenade_mp";
			class = "flash";
		break;
		case 2:
			special = "h1_concussiongrenade_mp";
			class = "smoke";
		break;
		case 3:
			special = "specialty_tacticalinsertion";
			class = "none";
		break;
	}
	level.special["grenade"] = special;
	//level.special["grenade"] = "specialty_tacticalinsertion";
	level.special["class"]   = class;
	level.loudout["special"] = level.special;
}

getRandomPerks(){
	perk1 = "none";
	perk2 = "none";
	perk3 = "none";
	switch(randomInt(3)){
		case 0:
			perk1 = "specialty_marathon_pro";
		break;
		case 1:
			perk1 = "specialty_fastreload_pro";
		break;
		case 2:
			perk1 = "specialty_scavenger_pro";
		break;
		default:
			perk1 = "specialty_marathon_pro";
		break;
	}
	switch(randomInt(2)){
		case 0:
			perk2 = "specialty_h2lightweight_pro";
		break;
		case 1:
			perk2 = "specialty_bulletdamage_pro";
		break;
		default:
			perk2 = "specialty_h2lightweight_pro";
		break;
	}
	switch(randomInt(4)){
		case 0:
			switch(randomInt(3)){
				case 2:
					perk3 = "specialty_detectexplosive_pro";
				break;
				default:
					perk3 = "specialty_ninja_pro";
				break;
			}
		break;
		case 1:
			switch(randomInt(3)){
				case 2:
					perk3 = "specialty_ninja_pro";
				break;
				default:
					perk3 = "specialty_commando_pro";
				break;
			}
		break;
		case 2:
			perk3 = "specialty_commando_pro";
		break;
		case 3:
			perk3 = "specialty_bulletaccuracy_pro";
		break;
		default:
			perk3 = "specialty_commando_pro";
		break;
	}
	level.perks["1"] = perk1;
	level.perks["2"] = perk2;
	level.perks["3"] = perk3;
	level.loudout["perk"] = level.perks;
}